function Fonts()
{
	this.mFont = LoadFont("Main.rfn");
	this.hFont = LoadFont("Little.rfn");
	this.tFont = LoadFont("Title.rfn");
	this.bFont = LoadFont("Buttons.rfn");
}

Fonts.prototype.drawText = function(x, y, text, alignment, color)
{
	if (color == undefined)
	{
		color = colors.white;
	}
	this.mFont.setColorMask(color);
	switch (alignment)
	{
		case "right":
			this.mFont.drawText(x - this.mFont.getStringWidth(text) + 1, y, text);
			break;
		case "center":
			this.mFont.drawText(x - (this.mFont.getStringWidth(text) + 1) / 2, y, text);
			break;
		default:
			this.mFont.drawText(x, y, text);
			break;
	}
}

Fonts.prototype.littleText = function(x, y, text, alignment, color)
{
	if (color == undefined)
	{
		color = colors.white;
	}
	this.hFont.setColorMask(color);
	switch (alignment)
	{
		case "right":
			this.hFont.drawText(x - this.mFont.getStringWidth(text) + 1, y, text);
			break;
		case "center":
			this.hFont.drawText(x - (this.mFont.getStringWidth(text) + 1) / 2, y, text);
			break;
		default:
			this.hFont.drawText(x, y, text);
			break;
	}
}

var font = new Fonts();